﻿namespace Hims.Api.Controllers
{
    using System.Net;
    using Domain.Configurations;
    using Microsoft.AspNetCore.Mvc;

    /// <summary>
    /// The home controller.
    /// </summary>
    public class HomeController : Controller
    {
        /// <summary>
        /// The API docs url.
        /// </summary>
        private readonly string apiDocsUrl;

        /// <summary>
        /// The identity server url.
        /// </summary>
        private readonly string identityServerUrl;

        /// <summary>
        /// The swagger url.
        /// </summary>
        private readonly string swaggerUrl;

        /// <summary>
        /// Initializes a new instance of the <see cref="HomeController"/> class.
        /// </summary>
        /// <param name="applicationConfiguration">
        /// The application configuration.
        /// </param>
        public HomeController(IApplicationConfiguration applicationConfiguration)
        {
            this.apiDocsUrl = applicationConfiguration.APILink + "api-docs";
            this.identityServerUrl = applicationConfiguration.APILink + ".well-known/openid-configuration";
            this.swaggerUrl = applicationConfiguration.APILink + "swagger/v" + applicationConfiguration.Version + "/swagger.json";
        }

        /// <summary>
        /// The index.
        /// </summary>
        /// <returns>
        /// The <see cref="IActionResult"/>.
        /// </returns>
        public IActionResult Index()
        {
            this.ViewBag.ApiDocsUrl = this.apiDocsUrl;
            this.ViewBag.IdentityServerUrl = this.identityServerUrl;
            this.ViewBag.SwaggerUrl = this.swaggerUrl;
            return this.View();
        }

        /// <summary>
        /// The index.
        /// </summary>
        /// <returns>
        /// The <see cref="IActionResult"/>.
        /// </returns>
        public IActionResult IdentityServer()
        {
            var client = new WebClient();
            this.ViewBag.Result = client.DownloadString(this.identityServerUrl);
            this.ViewBag.ApiDocsUrl = this.apiDocsUrl;
            return this.View();
        }

        /// <summary>
        /// The index.
        /// </summary>
        /// <returns>
        /// The <see cref="IActionResult"/>.
        /// </returns>
        public IActionResult Swagger()
        {
            var client = new WebClient();
            this.ViewBag.Result = client.DownloadString(this.swaggerUrl);
            this.ViewBag.ApiDocsUrl = this.apiDocsUrl;
            return this.View();
        }

        /// <summary>
        /// The Not Found.
        /// </summary>
        /// <returns>
        /// The <see cref="IActionResult"/>.
        /// </returns>
        public new IActionResult NotFound() => this.View("_NotFound");

        /// <summary>
        /// The error.
        /// </summary>
        /// <returns>
        /// The <see cref="IActionResult"/>.
        /// </returns>
        public IActionResult Error() => this.View("_Error");
    }
}